﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class WriteToMicroRWD_MemoryForm : Form
    {
        private MFICReader Reader { get; set; }

        public WriteToMemoryPanel Panel { get { return writeToMemoryPanel; } }

        public WriteToMicroRWD_MemoryForm()
        {
            InitializeComponent();
        }

        public WriteToMicroRWD_MemoryForm(int _count, ListView _listView, int _descriptionSubItem, MFICReader _reader)
        {
            InitializeComponent();

            Panel.Count = _count;
            Panel.DescriptionSubItem = _descriptionSubItem;
            Panel.ListView = _listView;

            Reader = _reader;
        }

        private void writeToMemoryPanel_Click_CloseButton(object sender, EventArgs e)
        {
            Close();
        }

        private void writeToMemoryPanel_Click_WriteButton(object sender, EventArgs e)
        {
            // If valid has been entered
            if (Panel.Data != null)
            {
                // Program MicroRWD EEPROM
                if (!Reader.CmdProgram(Panel.Address, Panel.Data[0]))
                {
                    // Write failed
                    Panel.Data = null;
                }

                // Refresh panel
                Panel.Modified = false;
                Panel.UpdateView();
            }
        }
    }
}
